﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.Model;


namespace IndianHealthService.BMXNet.EHR
{
    /// <summary>
    /// This interface is used to route EHR events to the common BMX context module.  
    /// </summary>
    /// <remarks>
    /// This interface is used by the EHR/VueCentric integration partial class, there is not need for
    /// BMX developers to directly use this interface
    /// </remarks>
    public interface IEhrEvents
    {
        /// <summary>
        /// This event is used internally by the EhrFramework
        /// </summary>
        event EventHandler<ContextChangedArgs> ContextChanged;
        
        /// <summary>
        /// This event is used internally by the EhrFramework
        /// </summary>
        event EventHandler<ContextChangingArgs> ContextChanging;
    }
}
